/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.model.DragonModel;
import net.adventurez.entity.render.feature.DragonEyesFeatureRenderer;
import net.adventurez.entity.render.feature.DragonSaddleFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

@Environment(value=EnvType.CLIENT)
public class DragonRenderer
extends MobRenderer<DragonEntity, DragonModel<DragonEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("adventurez:textures/entity/dragon.png");
    private static final ResourceLocation RED_DRAGON_TEXTURE = new ResourceLocation("adventurez:textures/entity/red_dragon.png");

    public DragonRenderer(EntityRendererProvider.Context context) {
        super(context, new DragonModel(context.m_174023_(RenderInit.DRAGON_LAYER)), 0.4f);
        this.m_115326_(new DragonEyesFeatureRenderer((RenderLayerParent<DragonEntity, DragonModel<DragonEntity>>)this));
        this.m_115326_(new DragonSaddleFeatureRenderer((RenderLayerParent<DragonEntity, DragonModel<DragonEntity>>)this));
    }

    public void render(DragonEntity dragonEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.f_114477_ = 0.6f * (float)dragonEntity.getSize();
        super.m_7392_((Mob)dragonEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public void scale(DragonEntity dragonEntity, PoseStack matrixStack, float f) {
        matrixStack.m_85841_((float)dragonEntity.getSize() / 3.0f, (float)dragonEntity.getSize() / 3.0f, (float)dragonEntity.getSize() / 3.0f);
    }

    public ResourceLocation getTexture(DragonEntity dragonEntity) {
        if (((Boolean)dragonEntity.m_20088_().m_135370_(DragonEntity.RED_DRAGON)).booleanValue()) {
            return RED_DRAGON_TEXTURE;
        }
        return TEXTURE;
    }
}

